{extends file="layouts/main.tpl"}

{block name=contents}

<div class="section-wrap">
    <div class="section">
        <img src="{$app.logo}" style="margin-left:44%; margin-bottom: 10px;" alt="">
        <div class="form-popup">
            {$form_alert}
            <!-- FORM POPUP CONTENT -->
            <div class="form-popup-content">
                <h4 class="popup-title">Login your Account</h4>
                <hr class="line-separator">
                <form id="demo-form" method="post" action="{$url.main}auth/grant_access">
                    {$csrf_token}
                    <label for="username5" class="rl-label">Username</label>
                    <input type="text" id="username5" name="username" placeholder="Enter your username here..." autofocus required>
                    <label for="password5" class="rl-label">Password</label>
                    <input type="password" id="password5" name="password" placeholder="Enter your password here..." required>
                    <!-- CHECKBOX -->
                    <input type="checkbox" id="remember2" name="do_rem" checked>
                    {* <label for="remember2" class="label-check">
                        <span class="checkbox primary primary"><span></span></span>
                        Remember username and password
                    </label> *}
                    <!-- /CHECKBOX -->
                    <p>Forgot your password? <a href="{$url.main}auth/reset_pass" class="primary">Click here!</a></p>
                    <p>Dont have an account? <a href="{$url.main}auth/signup" class="primary">Create free account</a></p>
                    <button type="submit" id="btn" name="do_login" class="g-recaptcha button mid dark" dark" data-sitekey="{$robot.p_key}" data-callback='onSubmit' {if $robot.isRobotCheck}disabled{/if}>Login <span class="primary">Now!</span></button>
                </form>
                <!-- LINE SEPARATOR -->
                <hr class="line-separator double">
                <!-- /LINE SEPARATOR -->
                <a href="{$fb_login}" class="button mid fb half">Login with Facebook</a>
                <a href="{$google_login}" class="button mid twt half">Login with Google</a>
            </div>
            <!-- /FORM POPUP CONTENT -->
        </div>
        <!-- /FORM POPUP -->
    </div>
</div>
    
{/block}

{block name=page_title}
<title>Login | {$app.name}</title>
{/block}

{block name=robot_check}
{if $robot.isRobotCheck}
    
    <script type="text/javascript" src="https://www.google.com/recaptcha/api.js" async defer></script>
<script type="text/javascript">
    {literal}
    function onSubmit(token) {
        document.getElementById('btn').disabled = false;
        document.getElementById("demo-form").submit();
    }
    {/literal}
</script>
{/if}
{/block}